/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.sonarlint.eclipse.core.internal.builder.SonarLintBuilder;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;

public class AnalyzeCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile editedFile;
        Map<IProject, Collection<IFile>> filesPerProject = this.findSelectedFilesPerProject(event);
        if (filesPerProject.isEmpty() && (editedFile = AnalyzeCommand.findEditedFile(event)) != null) {
            filesPerProject.put(editedFile.getProject(), Arrays.asList(editedFile));
        }
        if (!filesPerProject.isEmpty()) {
            this.runAnalysisJobs(filesPerProject);
        }
        return null;
    }

    private void runAnalysisJobs(Map<IProject, Collection<IFile>> filesPerProject) {
        for (Map.Entry<IProject, Collection<IFile>> entry : filesPerProject.entrySet()) {
            AnalyzeProjectJob job = new AnalyzeProjectJob(new AnalyzeProjectRequest(entry.getKey(), entry.getValue()));
            job.schedule();
            this.showIssuesViewAfterJobSuccess((Job)job);
        }
    }

    protected Map<IProject, Collection<IFile>> findSelectedFilesPerProject(ExecutionEvent event) throws ExecutionException {
        LinkedHashMap<IProject, Collection<IFile>> selectedFilesPerProject = new LinkedHashMap<IProject, Collection<IFile>>();
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)selection).toArray();
            AnalyzeCommand.collectFilesPerProject(selectedFilesPerProject, elems);
        }
        return selectedFilesPerProject;
    }

    private static void collectFilesPerProject(Map<IProject, Collection<IFile>> filesToAnalyzePerProject, Object[] elems) {
        Object[] objectArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            if (elem instanceof IResource) {
                AnalyzeCommand.collectChildren(filesToAnalyzePerProject, (IResource)elem);
            } else if (elem instanceof IAdaptable && ((IAdaptable)elem).getAdapter(IResource.class) != null) {
                AnalyzeCommand.collectChildren(filesToAnalyzePerProject, (IResource)((IAdaptable)elem).getAdapter(IResource.class));
            } else if (elem instanceof IWorkingSet) {
                IWorkingSet ws = (IWorkingSet)elem;
                AnalyzeCommand.collectFilesPerProject(filesToAnalyzePerProject, ws.getElements());
            }
            ++n2;
        }
    }

    private static void collectChildren(final Map<IProject, Collection<IFile>> filesToAnalyzePerProject, IResource elem) {
        try {
            elem.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!SonarLintBuilder.shouldAnalyze((IResource)resource)) {
                        return false;
                    }
                    IFile file = (IFile)resource.getAdapter(IFile.class);
                    if (file == null) {
                        return true;
                    }
                    IProject project = resource.getProject();
                    if (!filesToAnalyzePerProject.containsKey(project)) {
                        filesToAnalyzePerProject.put(project, new ArrayList());
                    }
                    ((Collection)filesToAnalyzePerProject.get(project)).add(file);
                    return true;
                }
            });
        }
        catch (CoreException e) {
            throw new IllegalStateException("Unable to collect files to analyze", e);
        }
    }

    protected static IFile findEditedFile(ExecutionEvent event) {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IEditorInput input = activeEditor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    protected void showIssuesViewAfterJobSuccess(Job job) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (Status.OK_STATUS == event.getResult()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchWindow iw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            try {
                                iw.getActivePage().showView("org.sonarlint.eclipse.ui.views.issues.IssuesView", null, 2);
                            }
                            catch (PartInitException e) {
                                SonarLintUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.sonarlint.eclipse.ui", 0, "Unable to open Issues View", (Throwable)e));
                            }
                        }
                    });
                }
            }
        });
        job.schedule();
    }
}

